/*
 * Die Sourcecodes, die diesem Buch als Beispiele beiliegen, sind
 * Copyright (c) 2006 - Thomas Ekert. Alle Rechte vorbehalten.
 * 
 * Trotz sorgfltiger Kontrolle sind Fehler in Softwareprodukten nie vollstndig auszuschlieen.
 * Die Sourcodes werden in Ihrem Originalzustand ausgeliefert.
 * Ansprche auf Anpassung, Weiterentwicklung, Fehlerbehebung, Support
 * oder sonstige wie auch immer gearteten Leistungen oder Haftung sind ausgeschlossen.
 * Sie drfen kommerziell genutzt, weiterverarbeitet oder weitervertrieben werden.
 * Voraussetzung hierfr ist, dass fr jeden beteiligten Entwickler, jeweils mindestens
 * ein Exemplar dieses Buches in seiner aktuellen Version als gekauftes Exemplar vorliegt.
 */
import java.util.Vector; import lotus.domino.*;
/**
 * 
 * @author Thomas Ekert
 *
 */
public class EmbeddedObjectAgent extends AgentBase {

	private static final String PATH = "C:\\temp\\";

	public void NotesMain() {
		Document doc = null;
		Database db = null; EmbeddedObject eo = null;
		RichTextItem rt = null;
		try {
			Session session = getSession();
			AgentContext agentContext = session.getAgentContext();
			db = agentContext.getCurrentDatabase();
			doc = agentContext.getDocumentContext();
			rt = (RichTextItem) doc.getFirstItem("F_richText");
			Vector v = rt.getEmbeddedObjects();
			for (int i = 0; i < v.size(); i++) {
				eo = (EmbeddedObject) v.elementAt(i);
				if (eo!=null) {
					System.out.println (eo.getName());
					System.out.println (eo.getSource());
					System.out.println (eo.getType());
					Vector verbs = eo.getVerbs();
					if (eo != null && verbs.size() > 0) {
						for (int k = 0; k < verbs.size(); k++) {
							System.out.println ("Verb = " + (String)verbs.elementAt(k));
						}
					} else {
						System.out.println ("Keine verbs");
					}
				} else {
					System.out.println ("Kein Embedded Object");
				}
			}
		} catch(Exception e) {
			e.printStackTrace();
		} finally {
			try {
				if (rt != null) {rt.recycle();}
				if (eo != null) {eo.recycle();}
				if (doc != null) {doc.recycle();}
				if (db != null) {db.recycle();}
			} catch (NotesException e1) {
				e1.printStackTrace();
			}
		}
	}
}
